<?php
/**********************************************************
* Source Copyright 2014 Author                            *
* Unauthorized reproduction is not allowed                *
* Author: JPK Software Solutions Pvt. Ltd.                *
* Email: sales@visionhelpdesk.com                         *
* Owner: www.visionhelpdesk.com                           *
**********************************************************/
if(!defined('_VIS_')) die('Error: Call from undefined function');
class changes {
    var $error;
	
	//************LIST FUNCTION************************************
	function view_changes($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff=new class_staff($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $object=new class_changes($database);
		
        $page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
        $sort_by=(isset($operation['vis_sort_by']))?$operation['vis_sort_by']:'';
        $operation['view_title']=$vis_language['TXTCHANGES'];
        $filter='';
		$data= isset($operation['vis_action']) && $operation['vis_action']!='' ? parse_form_array($operation['vis_action']) : $operation;
		$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
		$operation['filter_id']= (isset($action[4]))?$action[4]:$operation['vis_filter_id'];
        if(isset($data['vis_filter_id'])) $action[4]=$data['vis_filter_id']; 
        if(isset($operation['vis_filter_id'])) $action[4]=$operation['vis_filter_id']; 
		
		if(isset($operation['criteria']) && $operation['criteria']!='')
		{	
			$filter.=" ( ".VIS_TABLE_PREFIX."itil_changes.changes_hash='".addslashes($operation['criteria'])."' OR ".VIS_TABLE_PREFIX."itil_changes.subject like '%".addslashes($operation['criteria'])."%') and ";
			$criteria = $operation['criteria'];
        }

		if($action[4]==12)
        {
			$filter.=VIS_TABLE_PREFIX.'itil_changes.status_id!=3 and' ;
		}
		else if($action[4]==13)
		{
			$filter.=VIS_TABLE_PREFIX.'itil_changes.status_id=1 and ';
		}
		else if($action[4]==14)
		{
			$filter.=VIS_TABLE_PREFIX.'itil_changes.status_id=3 and ';
		}
		else if($action[4]==15)
		{
			$filter.='FIND_IN_SET ("'.VIS_STAFF_ID.'", '.VIS_TABLE_PREFIX.'itil_changes.staff_id) and ';
		}
		if(isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)
        {
		    if($data['search_department']!='') $filter .=" ".VIS_TABLE_PREFIX."itil_changes.department_id=".$data['search_department']." and ";
		    if($data['search_impact']!='') $filter .=" ".VIS_TABLE_PREFIX."itil_changes.impact_id=".$data['search_impact']." and ";
			if($data['search_priority']!='') $filter .=" ".VIS_TABLE_PREFIX."itil_changes.priority_id=".$data['search_priority']." and ";
		    if($data['search_risk']!='') $filter .=" ".VIS_TABLE_PREFIX."itil_changes.risk_id=".$data['search_risk']." and ";
		    if($data['search_status']!='') $filter .=" ".VIS_TABLE_PREFIX."itil_changes.status_id=".$data['search_status']." and ";
			 if($data['search_change_type']!='') $filter .=" ".VIS_TABLE_PREFIX."itil_changes.change_type_id=".$data['search_change_type']." and ";
		}
		$filter=substr($filter, 0, -4);
		
		list($view_info, $view_details)=$staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
        $limit=($page*$view_info['page_count']).','.$view_info['page_count'];
        list($changes_info, $changes_details)=$object->get_changes($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);		
        $view_info['page_count']=($changes_info['total']==0)?0:ceil($changes_info['total']/$view_info['page_count']);
		$view_info['view_count']=count($view_details);
		$changes_info['changes_count']=(!$changes_details || $changes_details==-1)?0:count($changes_details);
        $changes_info['page']=$page;
        // Code for api - start
		if(VIS_LOCATION_AREA==0) {
			if($changes_details!='') echo get_xml($changes_details, 'Changes');
			else echo $vis_language['MSGDATANOTFND'];
            return true;
        }
        // Code for api - end
        $database->database_disconnect();
        if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1) || (isset($operation['vis_action']) && $operation['vis_action']=='no_load')){
			ob_start();
			include(VIS_PATH_TEMPLATE.'changes_list.php');
			$changes_list = ob_get_clean();
			ob_end_flush();			
			$select='';
			$select .= "<div class=\"pull-right\">";
			$select .= "<select name=\"pageing\" id=\"paging\" class=\"form-control input-sm selectpicker pull-right paging v-middle\"  onChange=\"javascript:vis_apply_filter(this.value);\">";					  
			for($i=0;$i<$view_info['page_count'];$i++)
				$select.='<option value="'.$i.'" '.(($page==$i)?'selected="selected"':'').'>'.($i+1).'</option>';
			$select .= "</select><div class=\"text-muted pull-right label_page\">".$vis_language['TXTPAGE'].":</div>";
			
			echo json_encode(array('total_cnt'=>$changes_info['total'], 'paging' => $select, 'list'=> $changes_list));
		}else{
			include(VIS_PATH_TEMPLATE.'changes.php');
			echo '<script>$("#vis_right_panel_div").visExecution("load_area",{"vis_module":"home", "vis_operation":"load_right_panel","vis_current_module":"changes","vis_current_operations":"view_changes"});</script>';
		}	
        return true;
    }
	
	function delete_changes($operation) {
        global $vis_language;
        $operation['vis_current_operation']='filter_changes'; 
        $operation['vis_current_module']='changes'; 
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_changes($database);
		$sub_object=new class_subsetting($database);
		list($changes_info, $changes_details)=$object->get_changes($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$object->delete_changes($operation['vis_changes_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_changes_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed ".$chnages_details[0]['subject']." Change", VIS_STAFF_ID,7, VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'", vis_filter_id: "'.$operation['vis_filter_id'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }
	
	function get_changes_delete($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETECHANGE'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('submit_form', {'vis_module': 'changes', 'vis_operation': 'update_properties', 'vis_action': 'delete', 'vis_form':'vis_changes_form', 'vis_update_id': 0});";
        //$message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'changes', 'vis_operation':'delete_changes',  'vis_changes_id':".$operation['vis_changes_id'].", vis_filter_id: '".$operation['vis_filter_id']."'})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }

	/* NEW CHANGES FIRST STEP */
	function new_changes_step_one($operation) {
		global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $ticket=new class_ticket($database);
        $filter=(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1');
        $departments=$ticket->get_department($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX.'domain.domain_id');
        $departmentid = $departments[0]['department_id'];
       
        $database->database_disconnect();
		include(VIS_PATH_TEMPLATE.'changes_new_step_one.php');
        return true;
    }
	
	/*VIEW NEW PROBLEM FORM*/
    function new_changes($operation){
	global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $ticket=new class_ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$setting_object=new class_setting($database);
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff_object=new class_staff($database);
		
		if(!isset($operation['department_id'])){
			$this->new_changes_step_one($operation);
			return true;
		}
		list($operation['domain_id'], $operation['department_id'])=explode(':', $operation['department_id']);
        $vis_department_id= $operation['department_id'];
        $domain=$operation['domain_id'];	
		
		$staff_list = $staff_object->get_staff('is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA, $operation['department_id']);
		$login_staff = $staff_object->get_staff('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
    	
		$filter_condtn = '(department_access=0 or find_in_set('.$vis_department_id.', department_access))';
        $impact=$ticket_module->get_properties('get_impacts', '', $filter_condtn);
        $risk=$ticket_module->get_properties('get_risks', '', $filter_condtn);
        $change_type_details=$ticket_module->get_properties('get_changetype', '', $filter_condtn);
        $priorities=$ticket_module->get_properties('get_priorities', '', $filter_condtn);
		$status=$ticket_module->get_properties('get_status', '', $filter_condtn);

        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	$setting_object=new class_setting($database);
        $module_setting=$setting_object->get_module_setting('domain_id='.$operation['domain_id'].' and module_id=2', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $filter = 'is_enabled=1 and (department_access=0 or find_in_set('.$operation['department_id'].', department_access))';
		if(!isset($module_setting['vis_show_priority']) || $module_setting['vis_show_priority']==1 || $module_setting['vis_show_priority']==2){
			$module_setting['vis_priority']='';
			$priorities=$ticket->get_priorities_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1 and (department_access=0 or find_in_set('.$operation['department_id'].', department_access))');
		}
		if(!isset($module_setting['vis_show_tickettype']) || $module_setting['vis_show_tickettype']==1 || $module_setting['vis_show_tickettype']==2){
			$module_setting['vis_tickettype']='';
			$ticket_types=$ticket->get_type_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1 and (department_access=0 or find_in_set('.$operation['department_id'].', department_access))');
		}
		if(isset($module_setting['vis_show_level']) && ($module_setting['vis_show_level']==1 || $module_setting['vis_show_level']==2)){
			$module_setting['vis_level']='';
			list($ticket_level_count, $ticket_level_details)=$setting_object->get_ticket_level_list( $filter,'',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit);
		}
		if(isset($module_setting['vis_show_category']) && ($module_setting['vis_show_category']==1 || $module_setting['vis_show_category']==2)){
			$module_setting['vis_category']='';
			list($ticket_cat_count,$ticket_cat_details)=$setting_object->get_ticket_category_list($filter,'',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit);
		}
		if(VIS_ITIL==1){
			$location_assets=$setting_object->get_locations(" AND (".VIS_TABLE_PREFIX."itil_location.department_access = 0 OR FIND_IN_SET(".$operation['department_id'].", ".VIS_TABLE_PREFIX."itil_location.department_access)>0)",0, -1, '', VIS_STAFF_ID);
		}
		
		$database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'changes_new_step_two.php');
		
		echo '<script>$("#vis_right_panel_div").visExecution("load_area",{"vis_module":"home", "vis_operation":"load_right_panel","vis_current_module":"changes","vis_current_operations":"new_change","vis_filter_id":""});</script>';
        return true;
	}
	
	/* CHANGES ADDED*/
	function open_new_changes($operation) {      
        global $vis_language, $operation_hnd;
	    
        if(isset($operation['vis_action']))$data=parse_form_array($operation['vis_action']); else $data=$operation;
        if(!isset($data['vis_from']) || trim($data['vis_from'])==''){
			if(VIS_LOCATION_AREA==0) echo $vis_language['MSGREQFILFRMEMAIL'];
            else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQSTAFFSEMAIL'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_subject']) || trim($data['vis_subject'])==''){
			if(VIS_LOCATION_AREA==0) echo $vis_language['MSGREQSUB'];
            else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQSUB'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_description']) || trim(strip_tags($data['vis_description'],"<img>")) == ''){
			if(VIS_LOCATION_AREA==0) echo $vis_language['MSGREQFLDDESC'];
            else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDDESC'].'"); </script>';
            return false;
        }
		
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $cmdb_object=new class_cmdb($database);
		$data['vis_changes_hash']=$cmdb_object->get_itil_hash($data['vis_domain'], '10', 'vis_itil_changes_prefix', VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR==0) 
		$data['vis_description'] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_description']);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff=new class_staff($database);
		$staff_info=$staff->get_staff("email='".$data['vis_from']."'", VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($staff_info==-1){
			if(VIS_LOCATION_AREA==0) echo $vis_language['MSGINVFLDFRMEMAIL'];
			else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'. $vis_language['MSGINVFLDFRMEMAIL'].'"); </script>';
			return false;
		}
		$data['vis_from_name'] = $staff_info[0]['first_name'].' '.$staff_info[0]['last_name'];
		$data['vis_from_email'] = $staff_info[0]['email'];
		$data['vis_from']=$staff_info[0]['staff_id'];
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $database=new class_database();
        $changes_object=new class_changes($database);
		$ret=$changes_object->add_changes($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(VIS_LOCATION_AREA==0) {
            echo (!$ret)?'error':'success';
            return $ret;
        }
		if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'mail.php');
			$mobject=new class_mail($database);	
			$data1['changes_id'] = $ret['last_id'];
			$data1['vis_module']='itil_change';
			$data1['send_alert'] = true;
			$ret=$mobject->email_notify($data1, 'new_change', VIS_STAFF_ID, VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTALL'].'/12",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"filter_changes"});</script>';
		}
			
        return true;
    }

	function update_properties($operation) {
        global $vis_language;
        $list_chk=array();
		$database=new class_database();
		global $operation_hnd;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
		$changes_object=new class_changes($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $ticket_object=new class_ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
		
        if(isset($operation['vis_changes_id']) && is_numeric($operation['vis_changes_id'])) {
            $property=$operation['vis_action'];
            $list_chk[]=$operation['vis_changes_id'];
            $area=0;
        } else {
            $options=parse_form_array($operation['vis_action']);
            $property=$options['action'];
            $operation['vis_action']=$property;
            foreach($options as $data=>$value) if(preg_match('/vis_global_mass_chk_[0-9]/', $data)) $list_chk[]=$value;
            $area=1;
        }
		if(isset($operation['dept']) && $operation['dept']!=''){
            $department_list=array();
            for($i=0;$i<count($operation['dept']);$i++){
                $temp=explode('-',$operation['dept'][$i]);
                $department_list[$i]=$temp[0];
            }
        }
        if(empty($list_chk)){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        if(isset($operation['vis_update_id']) && is_numeric($operation['vis_update_id'])) {
           if($property=='priority')
			{
				 $filter='is_enabled=1 and priority_id='.$operation['vis_update_id'];
				 $priority_department=$ticket_object->get_priorities_list(VIS_STAFF_ID, VIS_LOCATION_AREA, $filter);
				 $priority_dept_access=explode(',', $priority_department[0]['department_access']);
				 if($priority_department[0]['department_access']!=0)
				 {
					for($k=0;$k<count($department_list);$k++){
						if(!in_array($department_list[$k], $priority_dept_access)) {
							unset($list_chk[$k]);
						}
					}
				 }
			}
			if($property=='status')
			{
				 $filter='is_enabled=1 and status_id='.$operation['vis_update_id'];
				 $status_department=$ticket_object->get_status_list($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
				 $status_dept_access=explode(',', $status_department[0]['department_access']);
				 if($status_department[0]['department_access']!=0)
				 {
					 for($k=0;$k<count($department_list);$k++){
						 if(!in_array($department_list[$k], $status_dept_access)) {
							 unset($list_chk[$k]);
						 }
					}	
				 }
			}
			if($property=='impact')
			{
				 $filter='is_enabled=1 and impact_id='.$operation['vis_update_id'];
				 list($impact_info, $impact_department)=$setting_object->get_impact($filter, '', '', 'display_order ASC', VIS_STAFF_ID, VIS_LOCATION_AREA);
				 $impact_dept_access=explode(',', $impact_department[0]['department_access']);
				 if($impact_department[0]['department_access']!=0)
				 {
					 for($k=0;$k<count($department_list);$k++){
						 if(!in_array($department_list[$k], $impact_dept_access)) {
							 unset($list_chk[$k]);
						 }
					}	
				 }
			}
			if($property=='risk')
			{
				 $filter='is_enabled=1 and risk_id='.$operation['vis_update_id'];
				 list($risk_info, $risk_department)=$setting_object->get_risk($filter, '', '', 'display_order ASC', VIS_STAFF_ID, VIS_LOCATION_AREA);
				 $risk_dept_access=explode(',', $risk_department[0]['department_access']);
				 if($risk_department[0]['department_access']!=0)
				 {
					 for($k=0;$k<count($department_list);$k++){
						 if(!in_array($department_list[$k], $risk_dept_access)) {
							 unset($list_chk[$k]);
						 }
					}	
				 }
			}
			if($property=='changetype')
			{
				 $filter='is_enabled=1 and change_type_id='.$operation['vis_update_id'];
				 list($release_type_info, $changetype_department)=$setting_object->get_change_type($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				 $changetype_dept_access=explode(',', $changetype_department[0]['department_access']);
				 if($changetype_department[0]['department_access']!=0)
				 {
					 for($k=0;$k<count($department_list);$k++){
						 if(!in_array($department_list[$k], $changetype_dept_access)) {
							 unset($list_chk[$k]);
						 }
					}	
				 }
			}
                        if($property=='category')
			{
				 $filter='is_enabled=1 and category_id='.$operation['vis_update_id'];
				 list($category_info, $category_department)=$setting_object->get_ticket_category_list($filter,'',VIS_STAFF_ID, VIS_LOCATION_AREA,"");
				 $category_dept_access=explode(',', $category_department[0]['department_access']);
				 if($category_department[0]['department_access']!=0)
				 {
					 for($k=0;$k<count($department_list);$k++){
						 if(!in_array($department_list[$k], $category_dept_access)) {
							 unset($list_chk[$k]);
						 }
					}	
				 }
			}
			
            $ret=$changes_object->set_changes_property($property, $operation, $list_chk, VIS_STAFF_ID, VIS_LOCATION_AREA);
            for($i=0;$i<count($list_chk);$i++) {
                $operation['vis_changes_id']=$list_chk[$i];
            }
            $database->database_disconnect();
            if(VIS_LOCATION_AREA==0) {
                echo ($ret)?'success':'error';
            }
            else {
               if(!$ret) {
                    $msg = ($property == 'department') ? $vis_language['MSGCHANGESMOVETODEPT'] : $vis_language['MSGACCSSDND'];
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$msg.'");$("[id^=\'vis_global_mass_chk_\']").attr("checked",false); </script>';
                    return false;
                }
                else {
					echo '<script>';
                    if($area==0) {
                        if($property=='delete')
                            echo "$('#vis_workpanel_div').visExecution('load_module', '".$vis_language['TXTCHANGES']."', {'vis_module':'changes', 'vis_operation':'filter_changes', 'vis_filter_id': 12});";
                        else {
                            echo ' $("#vis_details_list_'.$operation['vis_changes_id'].'").visExecution("load_area",{"vis_module":"changes", "vis_operation":"get_details", "vis_action":"details", "vis_changes_id":'.$operation['vis_changes_id'].'});';
                        } 
                    }
                    else{
						echo "$('#vis_workpanel_div').visExecution('load_area', {'vis_module':'changes', 'vis_operation':'filter_changes', 'vis_filter_id': '".$options['vis_filter_id']."','vis_tag':'tag'});";
					}
                    if($options['vis_export_function'] == 'filter_queue_changes' || $options['vis_export_function'] == 'view_changes') {  
					
					}
					echo '$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");';
                    echo '</script>';
                }
            }
            return $ret;
        }
        else {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
            return false;
        }
    }
	
	function filter_changes($operation) {
		
		if(isset($operation['vis_filter_id']) && is_numeric($operation['vis_filter_id'])) $filter_id=$operation['vis_filter_id']; 
        else if(isset($operation['vis_action']) && $operation['vis_action'] != ""){
			$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
			$action=explode($spliter, $operation['vis_action']);
			$operation['filter_id']= (isset($action[4]))?$action[4]:$operation['vis_filter_id'];
			
            if(isset($action[4]) && is_numeric($action[4])) {
                $operation['vis_filter_id'] = $filter_id=$action[4];
			}
        }
        else $filter_id=12;
		
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);   
        if(isset($operation['vis_page']) && is_numeric($operation['vis_page'])) {
            $page=$operation['vis_page'];
            if(isset($_COOKIE['vis_filter_id_page'])) $vis_filter_id_page=unserialize($_COOKIE['vis_filter_id_page']);
            $vis_filter_id_page[$filter_id]=$page;
            setcookie('vis_filter_id_page', serialize($vis_filter_id_page));
        } else {
            $page=0;
            if(isset($_COOKIE['vis_filter_id_page'])) {
                $vis_filter_id_page=unserialize($_COOKIE['vis_filter_id_page']);
                if(isset($vis_filter_id_page[$filter_id]) && is_numeric($vis_filter_id_page[$filter_id])) $page=$vis_filter_id_page[$filter_id];
            }
        }
		
        $sort_by=(isset($operation['vis_sort_by']))?$operation['vis_sort_by']:'';
        $filter=$changes_object->get_filter($filter_id, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($filter_id==12) $filter['filter'].= ' and '.VIS_TABLE_PREFIX.'itil_changes.status_id!=3';
        if($filter != ""){
			if(!isset($operation['view_title']))
            $operation['view_title']=$filter['filter_name'];
            $operation['filter_id']=$filter['filter_id'];
        } else {
            $operation['vis_filter_id'] = 1;
            return $this->filter_changes($operation);
        }
        $database->database_disconnect();
		
         if($filter['filter_name']=="Search Result")
			return $this->changes_display($operation, '', '', $filter['filter'], $page, $sort_by);
        else if($filter['filter_name']!="Search Result" && $filter['filter_name']!="Changes" )
			return $this->changes_display($operation, '', '', $filter['filter'], $page, $sort_by);
        else 
			return $this->changes_display($operation, '', '', $filter['filter'], $page, $sort_by);
    }
	
	function changes_display($operation, $and_conditions, $or_conditions, $filter='', $page=0, $sort_by='') {      
        global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff=new class_staff($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		$ticket=new class_ticket($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $object=new class_changes($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
		
        if(isset($operation['vis_filter_array']) && $operation['vis_filter_array']!='')
        {
			$filter=VIS_TABLE_PREFIX.'itil_changes.changes_id in ('.$operation['vis_filter_array'].')';
		}
		
		$quick_view=$object->get_changes_filter_counts('', VIS_STAFF_ID, VIS_LOCATION_AREA);
		list($view_info, $view_details)=$staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
        $limit=($page*$view_info['page_count']).','.$view_info['page_count'];
        list($changes_info, $changes_details)=$object->get_changes($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);		
        $view_info['page_count']=($changes_info['total']==0)?0:ceil($changes_info['total']/$view_info['page_count']);
		$view_info['view_count']=count($view_details);
		$view_info['view_title']=$operation['view_title'];
		$changes_info['changes_count']=(!$changes_details || $changes_details==-1)?0:count($changes_details);
        $changes_info['page']=$page;
		
		if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1) || (isset($operation['vis_action']) && $operation['vis_action']=='no_load')){
			ob_start();
			include(VIS_PATH_TEMPLATE.'changes_list.php');
			$changes_list = ob_get_clean();
			ob_end_flush();			
			$select='';
			$select .= "<div class=\"pull-right\">";
			$select = "<select name=\"pageing\" class=\"form-control input-sm selectpicker pull-right paging v-middle\" onchange=\"vis_apply_filter(this.value, '".$operation['vis_filter_id']."');\">";					  
			for($i=0;$i<$view_info['page_count'];$i++)
				$select.='<option value="'.$i.'" '.(($page==$i)?'selected="selected"':'').'>'.($i+1).'</option>';
			$select .= "</select><div class=\"text-muted pull-right label_page\">".$vis_language['TXTPAGE'].":</div>";
			
			echo json_encode( array('total_cnt'=>$changes_info['changes_count'], 'paging' => $select, 'list'=> $changes_list, 'filter_id'=>$operation['vis_filter_id']));
		}else{
			//--filter list data
			if(isset($operation['vis_action'])) $options=parse_form_array($operation['vis_action']);
			else $options=$operation;
			include(VIS_PATH_TEMPLATE.'changes.php');
			echo '<script>$("#vis_right_panel_div").visExecution("load_area",{"vis_module":"home", "vis_operation":"load_right_panel","vis_current_module":"changes","vis_current_operations":"view_changes","vis_filter_id":"'.$operation['filter_id'].'"});</script>';
		}
        $database->database_disconnect();
        return true;
    }
	
	function attach_changes_cmdb($operation) {
        global $vis_language;
	    include(VIS_PATH_TEMPLATE.'attach_cmdb_changes.php');
        return true;
    }
	
	function get_changes_list($operation){
		global $vis_language;
		$database=new class_database();
	    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);
		$filter = VIS_TABLE_PREFIX.'itil_changes.domain_id='.$operation['vis_domain_id']." AND ";
        if(isset($operation['vis_filter_enable'])){
			$filter .= VIS_TABLE_PREFIX."itil_changes.subject like '%".addslashes($operation['vis_filter'])."%' AND ";
		}
		if(VIS_CHANGES_VIEW_ACCESS==0){
			echo json_encode(array('vis_msg' => $vis_language['MSGACCSSDND']));
			return false;
		}
		$filter=substr($filter, 0, -4);
	    list($changes_info,$changes_details)=$changes_object->get_changes($filter, '50', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $tbl_data='';
		if($changes_details!=-1){
				$tbl_data .= '<table id="table_changes" class="table table-hover b-t b-light m-b-none">
								<thead class="table_head">
									<tr>
										<th></th>
										<th>'.$vis_language['TXTNAME'].'</th>
										<th>'.$vis_language['TXTDEPARTMENT'].'</th>
										<th>'.$vis_language['TXTSTATUS'].'</th>						
									</tr>
								</thead>';
			for($i=0;$i<count($changes_details);$i++){
					$tbl_data.='<tbody>
								<tr><td><label class="checkbox m-n i-checks"><input type="radio" name="vis_changes_id" id="vis_changes_id" value="'.$changes_details[$i]['changes_id'].'" /><i></i></label></td>';
					$tbl_data.='<td>'.$changes_details[$i]['subject'].'</td><td>'.$changes_details[$i]['department_name'].'</td><td>'.$changes_details[$i]['status_name'].'</td></tr>';
			}
				$tbl_data.='</tbody></table><script type="application/javascript">$(document).ready(function() {$("#table_changes").dataTable({ "sScrollY":  ( 0.6 * $(window).height() ),"bPaginate": false, "bJQueryUI": true, "bScrollCollapse": true, "bAutoWidth": "100%", "scrollX": true, "sScrollXInner": "100%","bFilter": false,"bInfo": false,"ordering": false});});</script>';
		}
		if($tbl_data==''){
				$tbl_data .='<div style="text-align:center;">'.$vis_language['TXTNOMATCHFOUND'].'</div>';
				$tbl_data .='<input type="hidden" name="total_itemrecord" id="total_itemrecord" value="0">';
		}else{
			$tbl_data .='<input type="hidden" name="total_itemrecord" id="total_itemrecord" value="'.count($changes_details).'">';
		}
		echo json_encode(array('list' => $tbl_data));
        return true;
	}
	function attach_cmdb_changes($operation) {
        global $vis_language;
		$data=parse_form_array($operation['vis_action']); 
		if(!isset($data['vis_changes_id'])) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGITILPLEASESELECTCHNAGES'].'"); </script>';
            return false;
        }
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
	    $database=new class_database();
        $changes_object=new class_changes($database);
		$ticket_object=new class_ticket($database);
		$ret=$changes_object->attach_cmdb_changes($data,VIS_STAFF_ID, VIS_LOCATION_AREA);
		$filter1=VIS_TABLE_PREFIX.'ticket.ticket_id='.$data['vis_ticket_id'];
		list($ticket_info, $ticket_details)=$ticket_object->get_ticket($filter1, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA); 
		$filter = " attach_type=6 AND child_id=".$data['vis_changes_id']." AND parent_id=".$data['vis_ticket_id'];
		list($total_ci, $attached_changes)=$changes_object->get_attach_changes($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$ticket_object->add_audit_log($ticket_details[0], 22, $attached_changes[0]['subject'],'', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$database->database_disconnect();
		if(!$ret) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_service_cost_form").dialog("close"); </script>';
		else{
			echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");';
			echo "$('#vis_details_list_".$data['vis_ticket_id']."').visExecution('load_operations',{'vis_module':'ticket', 'vis_operation':'get_details', 'vis_action':'details', 'vis_ticket_id':".$data['vis_ticket_id'].", 'vis_department_id':".$data['vis_dept_id'].", 'vis_readonly':1});$('.modal').modal('toggle'); </script>";
		}
    }
	function changes_details($operation) {
        global $vis_language;
        $database=new class_database(); 
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
        $staff_object=new class_staff($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);
        
		if(isset($operation['changes_id']) && is_numeric($operation['changes_id']) && !isset($operation['vis_changes_id'])) $operation['vis_changes_id']=$operation['changes_id'];
		if(isset($operation['vis_changes_id']) && is_numeric($operation['vis_changes_id'])) {
			$action=array('', 'changes', 'changes_details', '', $operation['vis_changes_id']);
		}
		else {
			$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
			$action=explode($spliter, $operation['vis_action']);
		}
		if(isset($action[4]) && $action[4]!='' && is_numeric($action[4])) {
			$filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$action[4];
		}
		else {
			$this->error=$vis_language['MSGCHANGESIDMISS'];
			return false;
		}
        
        list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		##reply all linked tickets		
		$filter = " attach_type=6 AND child_id=".$changes_details[0]['changes_id'];
		list($total_ticket, $attached_ticket)=$problem_object->get_ticket_attached_problem($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		###reply all linked tickets		
		
        if($changes_details==-1) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
		$changes_details=$changes_details[0];
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$sett_obj=new class_setting($database);
		
		
		
			
		$module_setting=$sett_obj->get_module_setting('(title="vis_show_note" or title="vis_show_custom_field") and domain_id='.$changes_details['domain_id'].' and module_id=2', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$note_details = $problem_object->get_note($changes_details['changes_id'], 4, 7, $changes_details['changes_from'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $staff_info=$staff_object->get_staff("staff_id='".$changes_details['changes_from']."'", VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		if($changes_details['attachment_id']!=''){ 
			$attachments=$problem_object->get_problem_attachment($changes_details['attachment_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
		}
		
		include(VIS_PATH_TEMPLATE.'changes_view.php');
		echo '<script>$("#vis_right_panel_div").visExecution("load_area",{"vis_module":"home", "vis_operation":"load_right_panel","vis_current_module":"changes","vis_current_operations":"changes_details"});</script>';
		return true;
    }
	function get_changes_properties($operation){
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);
        $filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$operation['vis_changes_id'];
        list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$changes_details=$changes_details[0];
		$database->database_disconnect();
        $message_info['changes_id']=(isset($operation['vis_changes_id']) && is_numeric($operation['vis_changes_id']))?$operation['vis_changes_id']:0;
        $message_info['staff_id']=(isset($operation['vis_staff_id']) && is_numeric($operation['vis_staff_id']))?$operation['vis_staff_id']:0;
        include(VIS_PATH_TEMPLATE.'changes_staff_properties.php');
        return true;
    }
	
	function update_changes_staff_properties($operation) {
        $data=parse_form_array($operation['vis_action']);
		 global $vis_language;
		  if(isset($data['vis_email']) || trim($data['vis_email'])!='')
		 {
			list($message, $flag) = check_email_validation($data['vis_email']);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
			} 
		 }        
		if(!isset($data['vis_subject']) || trim($data['vis_subject'])==''){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQSUB'].'"); </script>';
            return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
        $staff_object = new class_staff($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);
       
        $filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$data['vis_changes_id'];
        list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        if($changes_details==-1) return false;
        $changes_details=$changes_details[0];
		$filter =' email="'.$data['vis_email'].'"';
        $staff=$staff_object->get_staff($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($staff==-1) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGEMAILMISS'].'"); </script>';
            return false;
        }
        else {
			$data['staff_id']=$staff[0]['staff_id'];
			$ret=$changes_object->update_changes_staff($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
       
        $database->database_disconnect();
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $(".modal").modal("toggle"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"changes", "vis_operation":"changes_details", "vis_changes_id":'.$data['vis_changes_id'].'});  $("#vis_details_list_'.$data['vis_changes_id'].'").visExecution("load_area",{"vis_module":"changes", "vis_operation":"get_details", "vis_changes_id":'.$data['vis_changes_id'].', "vis_action":"details"});set_active_tab("ticket_details"); </script>';
        return true;
    }
	function get_details($operation) {
        global $vis_language;
		switch($operation['vis_action']) {
            case 'details':
                if(isset($operation['vis_changes_id']) && is_numeric($operation['vis_changes_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
                    $ticket_object=new class_ticket($database);
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
					$changes_object=new class_changes($database);
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
					$problem_object=new class_problem($database);
                    $filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$operation['vis_changes_id'];
					list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
					
					if($changes_details==-1) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBNTACC'].'"); $(this).visInterface("remove_tab", "vis_module_ticket_div"); </script>';
                        return false;
                    }
					$changes_details=$changes_details[0];
					
					$filter = " attach_type=9 AND parent_id=".$changes_details['changes_id'];
					list($total_ci, $attached_ci)=$problem_object->get_attach_ci($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
					$filter = " attach_type=6 AND child_id=".$changes_details['changes_id'];
					list($total_ticket, $attached_ticket)=$problem_object->get_ticket_attached_problem($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
					$filter = " attach_type=2 AND child_id=".$changes_details['changes_id'];
					list($total_problem, $attached_problem)=$changes_object->get_attached_problem($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
					$filter = " attach_type=3 AND parent_id=".$changes_details['changes_id'];
					list($total_release, $attached_release)=$changes_object->get_attached_release($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
					$filter = " attach_type=10 AND parent_id=".$changes_details['changes_id'];
					list($total_task, $attached_task)=$problem_object->get_task_attachedto_problem($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
					$filter=(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'department.department_id='.$changes_details['department_id'].' and '.VIS_TABLE_PREFIX.'domain.domain_id='.$changes_details['domain_id'].' and '.VIS_TABLE_PREFIX.'domain.is_enabled=1');
				    $departments=$ticket_object->get_department($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX.'domain.domain_id');
        			$owner_details=-1;
                    if($changes_details['staff_id']!='' && $changes_details['staff_id']!='0'){
						$owner_details=$problem_object->get_problem_owner($changes_details['staff_id']);
					}
                    $filter = " aprovals_type=0 AND ".VIS_TABLE_PREFIX."itil_changes_aprovals.is_enabled=1 AND parent_id=".$changes_details['changes_id'];
					list($total_aprovals, $aprovals_details)=$changes_object->get_aprovals($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);

					$filter = " aprovals_type=0 AND ".VIS_TABLE_PREFIX."itil_changes_aprovals.is_enabled=1 AND ".VIS_TABLE_PREFIX."itil_changes_aprovals.staff_id=".VIS_STAFF_ID." AND parent_id=".$changes_details['changes_id'];
					list($single_aprovals, $single_details)=$changes_object->get_aprovals($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
					$filter= ' is_enabled=1 AND parent_id='.$changes_details['changes_id'];
					$aprovals_status=$changes_object->get_aprovals_status($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
                   include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	           $setting_object=new class_setting($database);
                   $module_setting=$setting_object->get_module_setting('domain_id='.$changes_details['domain_id'].' and module_id=2', VIS_STAFF_ID, VIS_LOCATION_AREA);
                   $filter = 'is_enabled=1 and (department_access=0 or find_in_set('.$operation['department_id'].', department_access))';
		   if(isset($module_setting['vis_show_category']) && ($module_setting['vis_show_category']==1 || $module_setting['vis_show_category']==2)){
			$module_setting['vis_category']='';
			list($ticket_cat_count,$ticket_cat_details)=$setting_object->get_ticket_category_list($filter,'',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit);
		}
		if(VIS_ITIL==1){
			$location_assets=$setting_object->get_locations(" AND (".VIS_TABLE_PREFIX."itil_location.department_access = 0 OR FIND_IN_SET(".$operation['department_id'].", ".VIS_TABLE_PREFIX."itil_location.department_access)>0)",0, -1, '', VIS_STAFF_ID);
		}
                    $database->database_disconnect();
                    include_once(VIS_PATH_TEMPLATE.'changes_details.php');
					if(isset($operation['open_aprovals']) && $operation['open_aprovals']=='yes'){
						echo "<script>$('#vis_show_attach_all_".$changes_details['changes_id']."').visExecution('load_operations',{'vis_module':'changes', 'vis_operation':'get_details', 'vis_action':'aprovals', 'vis_changes_id':'".$changes_details['changes_id']."'});</script>";
					}
                    return true;
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCHANGESIDMISS'].'"); </script>';
                    return false;
                }
            break;
            case 'audit_log':
                if(isset($operation['vis_changes_id']) && is_numeric($operation['vis_changes_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
                    $object=new class_ticket($database);
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');  
                    $staff=new class_staff($database);
					list($view_info, $view_details)=$staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
                    $page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;     
					$limit=($page*$view_info['page_count']).','.$view_info['page_count'];	
                    list($audit_log_info, $audit_log)=$object->audit_log($operation['vis_changes_id'], $limit, $page, VIS_STAFF_ID, VIS_LOCATION_AREA, 2);
                    $view_info['page_count']=($audit_log_info['total']==0)?0:ceil($audit_log_info['total']/$view_info['page_count']);
					$audit_log_info['page']=$page;
					$view_info['view_count']=count($view_details);
                    $audit_count=($audit_log==-1)?0:count($audit_log);
                    for($i=0 ; $i<$audit_count ; $i++)
                    {
						switch($audit_log[$i]['operation_id']) {
							case '0':
								include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');  
								$object=new class_setting($database);
								$staff_details=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$audit_log[$i]['operator_id'], '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
								$staff_name =  $staff_details[1][0]['first_name'].' '.$staff_details[1][0]['last_name'];
								$audit_log[$i]['audit_log_operation']=$vis_language['MSGNEWCHANGE'].' by '.$staff_name;
								
								break;
								
							case '1':
								$audit_log[$i]['audit_log_operation']='Risk updated from '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
								break;
							
							case '2':
								$audit_log[$i]['audit_log_operation'] = 'Status updated from '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
								break;
								
							case '3':
								$audit_log[$i]['audit_log_operation'] = 'Priority updated from '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
								break;
								
							case '4':
								$audit_log[$i]['audit_log_operation'] = 'Department updated from '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
								break;
								
							case '5':
								$audit_log[$i]['audit_log_operation'] = 'Impact updated from '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
								break;
								
							case '6':
								$audit_log[$i]['audit_log_operation'] = 'Changes properties updated';
								break;
								
							case '7':
								include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');  
								$object=new class_setting($database);
								$staff_new_info=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$audit_log[$i]['new_info'], '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
								$new_info =  $staff_new_info[1][0]['first_name'].' '.$staff_new_info[1][0]['last_name'];
								if($audit_log[$i]['new_info']!=0 && $staff_new_info[1]!=-1)
									$audit_log[$i]['audit_log_operation'] = 'Changes assigned to '. $new_info;
								elseif($audit_log[$i]['new_info']==0 && $audit_log[$i]['old_info']>0){ 
									$staff_old_info=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$audit_log[$i]['old_info'], '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
									$old_info =  $staff_old_info[1][0]['first_name'].' '.$staff_old_info[1][0]['last_name'];
									$audit_log[$i]['audit_log_operation'] = 'Changes unassigned From '. $old_info;
								}
								else
									$audit_log[$i]['audit_log_operation'] = 'Changes assigned to Nobody';
								break;
								
							case '8':
								$audit_log[$i]['audit_log_operation'] = 'Type changed from '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
								break;
								
							case '9':
								$audit_log[$i]['audit_log_operation'] = 'Changes description updated';
								break;
							
							case '10':
								$audit_log[$i]['audit_log_operation'] = 'Linked CI '. $audit_log[$i]['old_info'];
								break;
							
							case '11':
								$audit_log[$i]['audit_log_operation'] = 'Linked ticket '. $audit_log[$i]['old_info'];
								break;
							
							case '12':
								$audit_log[$i]['audit_log_operation'] = 'Linked problem '. $audit_log[$i]['old_info'];
								break;
							
							case '13':
								$audit_log[$i]['audit_log_operation'] = 'Linked release '. $audit_log[$i]['old_info'];
								break;
							

							case '14':
								$audit_log[$i]['audit_log_operation'] = 'Linked task '. $audit_log[$i]['old_info'];
								break;
															
							case '15':
								$audit_log[$i]['audit_log_operation'] = 'Detach CI '. $audit_log[$i]['old_info'];
								break;
															
							case '16':
								$audit_log[$i]['audit_log_operation'] = 'Detach ticket '. $audit_log[$i]['old_info'];
								break;
															
							case '17':
								$audit_log[$i]['audit_log_operation'] = 'Detach problem '. $audit_log[$i]['old_info'];
								break;
							
							case '18':
								$audit_log[$i]['audit_log_operation'] = 'Detach release '. $audit_log[$i]['old_info'];
								break;
								
							case '19':
								$audit_log[$i]['audit_log_operation'] = 'Detach task '. $audit_log[$i]['old_info'];
								break;
															
							case '20':
								$audit_log[$i]['audit_log_operation'] = 'Sent approval request to '. $audit_log[$i]['old_info'];
								break;
															
							case '21':
								$audit_log[$i]['audit_log_operation'] = $audit_log[$i]['old_info'].' approval';
								break;
							
							case '22':
								$audit_log[$i]['audit_log_operation'] = 'Reasons for change updated';
								break;
								
							case '23':
								$audit_log[$i]['audit_log_operation'] = 'Planning impact updated';
								break;
							
							case '24':
								$audit_log[$i]['audit_log_operation'] = 'Rollout plan updated';
								break;
							
							case '25':
								$audit_log[$i]['audit_log_operation'] = 'Backout plan updated';
								break;
								
							case '26':
								$audit_log[$i]['audit_log_operation'] = 'Reasons for change deleted';
								break;
								
							case '27':
								$audit_log[$i]['audit_log_operation'] = 'Planning impact deleted';
								break;
							
							case '28':
								$audit_log[$i]['audit_log_operation'] = 'Rollout plan deleted';
								break;
							
							case '29':
								$audit_log[$i]['audit_log_operation'] = 'Backout plan deleted';
								break;
							
							case '30':
								$audit_log[$i]['audit_log_operation'] = 'Sent approval reminder to '. $audit_log[$i]['old_info'];
								break;
                                                        case '46':
									$audit_log[$i]['audit_log_operation']=$vis_language['MSGTICKETCATEGORYCHANGED'].' '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
									break;
								case '47':
									$audit_log[$i]['audit_log_operation']=$vis_language['MSGTICKETSUBCATEGORYCHANGED'].' '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
									break;
								case '48':
									$audit_log[$i]['audit_log_operation']=$vis_language['MSGTICKETITEMCHANGED'].' '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
									break;
								case '49':
									$audit_log[$i]['audit_log_operation']=$vis_language['MSGITILLOCATIONCHANGED'].' '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
									break;
						}
					}
                    $database->database_disconnect();
                    if(VIS_LOCATION_AREA==0) {
                        echo get_xml($audit_log, 'audit_log');
                        return true;
                    }
                    else {
                        include_once(VIS_PATH_TEMPLATE.'changes_audit_log.php');
                        return true;
                    }
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCHANGESIDMISS'].'"); </script>';
                    return false;
                }
            break;
			case 'notes':
				if(isset($operation['vis_changes_id']) && is_numeric($operation['vis_changes_id'])) {
                    $database=new class_database();
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
                    $problem_object=new class_problem($database);
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
					$sett_obj=new class_setting($database);
                    $module_setting=$sett_obj->get_module_setting('title="vis_show_note" and domain_id='.$operation['vis_domain_id'].' and module_id=2', VIS_STAFF_ID, VIS_LOCATION_AREA); 
					$note_details=(VIS_NOTE_ACCESS==0)?-1:$problem_object->get_note($operation['vis_changes_id'], 4,7, $operation['vis_client_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
					include(VIS_PATH_TEMPLATE."changes_note_details.php");
					return true;
				}
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCHANGESIDMISS'].'"); </script>';
                    return false;
                }
            break;
			case 'planning':
                if(isset($operation['vis_changes_id']) && is_numeric($operation['vis_changes_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
                    $problem_object=new class_problem($database);
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
					$changes_object=new class_changes($database);
                    $filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$operation['vis_changes_id'];
					list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($changes_details==-1) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBNTACC'].'");</script>';
                        return false;
                    }
					$changes_details=$changes_details[0];$attachments=-1;
					if($operation['vis_planning_type']=='reasons'){
						if($changes_details['reasons_attachment']!=''){ 
							$attachments=$problem_object->get_problem_attachment($changes_details['reasons_attachment'], VIS_STAFF_ID, VIS_LOCATION_AREA);
						}
					}
					if($operation['vis_planning_type']=='impact'){
						if($changes_details['impact_attachment']!=''){ 
							$attachments=$problem_object->get_problem_attachment($changes_details['impact_attachment'], VIS_STAFF_ID, VIS_LOCATION_AREA);
						}
					}
					$database->database_disconnect();
                    include_once(VIS_PATH_TEMPLATE.'changes_planning_list.php');
                    return true;
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCHANGESIDMISS'].'"); </script>';
                    return false;
                }
            case 'plan':
                if(isset($operation['vis_changes_id']) && is_numeric($operation['vis_changes_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
                    $problem_object=new class_problem($database);
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
					$changes_object=new class_changes($database);
					
                    $filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$operation['vis_changes_id'];
					list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($changes_details==-1) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBNTACC'].'"); $(this).visInterface("remove_tab", "vis_module_ticket_div"); </script>';
                        return false;
                    }
					$changes_details=$changes_details[0];
					$rollout_attachment = $backout_attachment = -1;
					
					if($changes_details['rollout_attachment']!=''){ 
						$rollout_attachment=$problem_object->get_problem_attachment($changes_details['rollout_attachment'], VIS_STAFF_ID, VIS_LOCATION_AREA);
					}
					if($changes_details['backout_attachment']!=''){ 
						$backout_attachment	=$problem_object->get_problem_attachment($changes_details['backout_attachment'], VIS_STAFF_ID, VIS_LOCATION_AREA);
					}
							
                    $database->database_disconnect();
                    include_once(VIS_PATH_TEMPLATE.'changes_plan_list.php');
                    return true;
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCHANGESIDMISS'].'"); </script>';
                    return false;
                }
            case 'analysis_solution':
                if(isset($operation['vis_changes_id']) && is_numeric($operation['vis_changes_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
                    $ticket_object=new class_ticket($database);
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
                    $problem_object=new class_problem($database);
                    $filter=VIS_TABLE_PREFIX.'itil_problems.changes_id='.$operation['vis_changes_id'];
					list($problems_info, $changes_details)=$problem_object->get_problems($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($changes_details==-1) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBNTACC'].'"); $(this).visInterface("remove_tab", "vis_module_ticket_div"); </script>';
                        return false;
                    }
                    if(VIS_LOCATION_AREA==0) {
                        echo get_xml($ticket_details, 'ticket');
                        return true;
                    }
                    else {
                        $view_info['page_count']=($ticket_info['total']==0)?0:ceil($ticket_info['total']/$view_info['page_count']);
                        $ticket_info['ticket_count']=(!$ticket_details || $ticket_details==-1)?0:count($ticket_details);
                        if($operation['vis_ticket']==1)
                        $ticket_info['page']=$page;
                        else
                        $ticket_info['page']=$page*$view_info['page_count'];
                        $view_info['view_count']=count($view_details);
                        if(isset($operation['vis_changes_id']) && is_numeric($operation['vis_changes_id'])) $ticket_id=$operation['vis_changes_id'];
                        else $ticket_id=0;
                        foreach($view_details as $v){
							if($ticket_details!=-1){			
								for($i=0;$i<count($ticket_details);$i++){
									switch($v['tab_name']){
										case 'link': 	
											$link_data=array('vis_changes_id'=>$ticket_details[$i]['ticket_id'], 'case'=>1);	
											$link = $ticket_object->get_ticket_link($link_data, VIS_STAFF_ID, VIS_LOCATION_AREA);
											$ticket_details[$i]['link_present']=($link == -1)?0:1;
											break;
										case 'label':	
											$label_details[$i] = $ticket_object->get_ticket_labels($ticket_details[$i]['ticket_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
											break;
										default: // this case will execute at last
											$ticket_lock[$i] = $ticket_object->get_ticket_lock($ticket_details[$i]['ticket_id'], 'staff_id!='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
									}
								}
							}
						}
                        include_once(VIS_PATH_TEMPLATE.'problems_list.php');
                    }
					$changes_details=$changes_details[0];
					                                                
                    $database->database_disconnect();
                    include_once(VIS_PATH_TEMPLATE.'new_analysis_solution.php');
                    return true;
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCHANGESIDMISS'].'"); </script>';
                    return false;
                }
            break;
			case 'attach_ci':
                if(isset($operation['vis_changes_id']) && is_numeric($operation['vis_changes_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
                    $changes_object=new class_changes($database);
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
					$problem_object=new class_problem($database);
					
                    $filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$operation['vis_changes_id'];
					list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($changes_details==-1) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBNTACC'].'"); $(this).visInterface("remove_tab", "vis_module_ticket_div"); </script>';
                        return false;
                    }
					$changes_details=$changes_details[0];
					$filter = " attach_type=9 AND parent_id=".$changes_details['changes_id'];
					list($total_ci, $attached_ci)=$problem_object->get_attach_ci($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);                                              
                    $database->database_disconnect();
                    include_once(VIS_PATH_TEMPLATE.'changes_attach_ci_list.php');
                    return true;
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCHANGESIDMISS'].'"); </script>';
                    return false;
                }
            break;
			case 'attach_ticket':
                if(isset($operation['vis_changes_id']) && is_numeric($operation['vis_changes_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
                    $problem_object=new class_problem($database);
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
					$changes_object=new class_changes($database);
					
                    $filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$operation['vis_changes_id'];
					list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($changes_details==-1) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBNTACC'].'"); $(this).visInterface("remove_tab", "vis_module_ticket_div"); </script>';
                        return false;
                    }
					$changes_details=$changes_details[0];
					$filter = " attach_type=6 AND child_id=".$changes_details['changes_id'];
					list($total_ticket, $attached_ticket)=$problem_object->get_ticket_attached_problem($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);                                              
                    $database->database_disconnect();
                    include_once(VIS_PATH_TEMPLATE.'changes_attached_ticket_list.php');
                    return true;
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCHANGESIDMISS'].'"); </script>';
                    return false;
                }
            break;
			case 'attach_release':
                if(isset($operation['vis_changes_id']) && is_numeric($operation['vis_changes_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
                    $problem_object=new class_problem($database);
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
					$changes_object=new class_changes($database);
					
                    $filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$operation['vis_changes_id'];
					list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
					
					if($changes_details==-1) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBNTACC'].'"); $(this).visInterface("remove_tab", "vis_module_ticket_div"); </script>';
                        return false;
                    }
					$changes_details=$changes_details[0];
					$filter = " attach_type=3 AND parent_id=".$changes_details['changes_id'];
					list($total_release, $attached_release)=$changes_object->get_attached_release($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
                    $database->database_disconnect();
                    include_once(VIS_PATH_TEMPLATE.'changes_attached_release_list.php');
                    return true;
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCHANGESIDMISS'].'"); </script>';
                    return false;
                }
            break;
			case 'attach_task':
                if(isset($operation['vis_changes_id']) && is_numeric($operation['vis_changes_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
                    $problem_object=new class_problem($database);
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
					$changes_object=new class_changes($database);
                    $filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$operation['vis_changes_id'];
					list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($changes_details==-1) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBNTACC'].'"); $(this).visInterface("remove_tab", "vis_module_ticket_div"); </script>';
                        return false;
                    }
					$changes_details=$changes_details[0];
					$filter = " attach_type=10 AND ".VIS_TABLE_PREFIX."itil_relation.parent_id=".$changes_details['changes_id'];
					list($total_task, $attached_task)=$problem_object->get_task_attachedto_problem($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
                    $database->database_disconnect();
                    include_once(VIS_PATH_TEMPLATE.'changes_attached_task_list.php');
                    return true;
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCHANGESIDMISS'].'"); </script>';
                    return false;
                }
            break;
			case 'attach_problem':
                if(isset($operation['vis_changes_id']) && is_numeric($operation['vis_changes_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
                    $problem_object=new class_problem($database);
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
					$changes_object=new class_changes($database);
					
                    $filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$operation['vis_changes_id'];
					list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($changes_details==-1) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBNTACC'].'"); $(this).visInterface("remove_tab", "vis_module_ticket_div"); </script>';
                        return false;
                    }
					$changes_details=$changes_details[0];
										
					$filter = " attach_type=2 AND child_id=".$changes_details['changes_id'];
					list($total_problem, $attached_problem)=$changes_object->get_attached_problem($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
                    $database->database_disconnect();
                    include_once(VIS_PATH_TEMPLATE.'changes_attached_problem_list.php');
                    return true;
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCHANGESIDMISS'].'"); </script>';
                    return false;
                }
            break;
			case 'aprovals':
                if(isset($operation['vis_changes_id']) && is_numeric($operation['vis_changes_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
                    $changes_object=new class_changes($database);
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
					$problem_object=new class_problem($database);
					
                    $filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$operation['vis_changes_id'];
					list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($changes_details==-1) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCHANGESIDMISS'].'"); $(this).visInterface("remove_tab", "vis_module_ticket_div"); </script>';
                        return false;
                    }
					
					$changes_details=$changes_details[0];
					$filter = " aprovals_type=0 AND ".VIS_TABLE_PREFIX."itil_changes_aprovals.is_enabled=1 AND parent_id=".$changes_details['changes_id'];
					list($total_aprovals, $aprovals_details)=$changes_object->get_aprovals($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
					$filter2 = " aprovals_type=0 AND remark!='' AND parent_id=".$changes_details['changes_id'];
					list($total_remark, $remark_details)=$changes_object->get_aprovals($filter2, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
                    $database->database_disconnect();
                    include_once(VIS_PATH_TEMPLATE.'changes_aprovals_list.php');
                    return true;
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCHANGESIDMISS'].'"); </script>';
                    return false;
                }
            break;
        }
        if(VIS_LOCATION_AREA==2) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVOPT'].' '.$operation['vis_action'].'"); </script>';
        else echo 'error';
        return false;
    }
	
	function new_note($operation){
        $message_info['changes_id']=(isset($operation['vis_changes_id']) && is_numeric($operation['vis_changes_id']))?$operation['vis_changes_id']:0;
        $message_info['staff_id']=(isset($operation['vis_staff_id']) && is_numeric($operation['vis_staff_id']))?$operation['vis_staff_id']:0;
        include(VIS_PATH_TEMPLATE.'changes_note.php');
		return true;
    }
	
	function add_note($operation) {
        global $vis_language, $operation_hnd;
        if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        if(trim($data['vis_note'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");</script>';
            return false;
        }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $change_object=new class_changes($database);
        $data['vis_note']=nl2br($data['vis_note']);
		$data['vis_id'] = $data['vis_changes_id'];
        $result = $change_object->add_note($data,4,7, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $data=array_merge($data, $operation);
        if(VIS_LOCATION_AREA==0) {
            echo ($result)?'success':'error';
        }
        else {
            if($result){
			    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
                $sett_obj=new class_setting($database);
                if(VIS_GAMIFICATION_ACCESS == 1) 
                {
                     include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
                     $staff=new class_staff($database);
                     $staff_info=$staff->get_staff('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
                     $points = $sett_obj->calculate_points($staff_info[0],7,IS_STAFF_ID,VIS_LOCATION_AREA); 
                }
				$module_setting=$sett_obj->get_module_setting('title="vis_show_note" and domain_id='.$data['vis_domain_id'].' and module_id=2', VIS_STAFF_ID, VIS_LOCATION_AREA); 
				$note_details=(VIS_NOTE_ACCESS==0)?-1:$problem_object->get_note($data['vis_changes_id'], 4,7, $data['vis_staff_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
				echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$(".modal").modal("toggle");';
				$active_tab="";
			
					$active_tab="notes";
					echo '$("#vis_details_list_'.$data['vis_changes_id'].'").visExecution("load_area", {"vis_module":"changes", "vis_operation":"get_details", "vis_action":"notes", "vis_changes_id":'.$data['vis_changes_id'].',"vis_client_id":'.$data['vis_staff_id'].',"vis_domain_id":'.$data['vis_domain_id'].'});';
				
				echo 'set_active_tab("'.$active_tab.'");</script>';
            }
            else{
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
            }
        }
        return $result;
        $database->database_disconnect();
    }
	function confirm_delete_note($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETENOTE'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$(this).visExecution('load_operations', {'vis_module':'changes', 'vis_operation':'delete_note', 'vis_remark_id':".$operation['vis_remark_id'].", 'vis_changes_id':".$operation['vis_changes_id']."});";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }

    function delete_note($operation) {
        global $vis_language;
        $database = new class_database();
		
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object = new class_problem($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);
        $filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$operation['vis_changes_id'];
        list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		
        $changes_details=$changes_details[0];
		
        $result = $problem_object->delete_note($operation['vis_remark_id'],7, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $note_details = $problem_object->get_note($changes_details['changes_id'], 4, 7, $changes_id['changes_from'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $note_count=count($note_details);
	   
        $database->database_disconnect();
        
		if($result) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");';
			if($note_count==0)
			{
				echo '$("#vis_workpanel_div").visExecution("load_area",{"vis_module":"changes", "vis_operation":"changes_details", "vis_changes_id":"'.$operation['vis_changes_id'].'"});</script>';
			}
			else
			{
				echo '$("#ticket_note_'.$operation['vis_remark_id'].'").remove();';
				echo 'if(!$("#ticket_details.active").length && $("[id^=\'ticket_note_\']:first").hasClass("m-t-sm")) $("[id^=\'ticket_note_\']:first").removeClass("m-t-sm");</script>';
			}
		}
		else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
        
        return $result;
    }
	function changes_description_edit($operation){
        $database = new class_database();
        
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
		 
        $changes_object=new class_changes($database);
        $filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$operation['vis_changes_id'];
        list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		
        $database->database_disconnect();
        $changes_details=$changes_details[0];
        if (defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR != 1) {  	
        $changes_details['description'] = get_plain_text($changes_details['description']);
		}
        include(VIS_PATH_TEMPLATE.'changes_description_edit.php');
        return true;
    }
	function update_changes_description($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);
        
        if(!isset($data['vis_changes_desc']) || trim(strip_tags($data['vis_changes_desc'],"<img>")) == ''){
			if(VIS_LOCATION_AREA==0) echo $vis_language['MSGREQFLDDESC'];
            else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDDESC'].'"); </script>';
            return false;
        }
        if(defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR==0) 
        $data['vis_changes_desc'] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_changes_desc']);
		$result=$changes_object->update_changes_description($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if(!$result)
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
        else
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_ticket_post_content_text_'.$data['vis_changes_id'].'").show(); $("#vis_ticket_post_content_edit_'.$data['vis_changes_id'].'").hide(); $("#vis_ticket_post_content_text_'.$data['vis_changes_id'].'").html("'.$data['vis_changes_desc'].'"); </script>';
        return $result;
    }
	
	function attach_ticket($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);
		
		if(isset($operation['vis_attach_ticket']) && $operation['vis_attach_ticket']=='success'){
			$data=parse_form_array($operation['vis_action']);
			
			if($data['total_attach_count']>0){
				$data['vis_attach_type']=6;
				$data['vis_child_id']=$data['vis_changes_id'];
				$filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$data['vis_changes_id'];
				list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				for($i=0;$i<$data['total_attach_count'];$i++){
					
					if(isset($data['vis_attach_id_'.$i])){
						$data['vis_parent_id']=$data['vis_attach_id_'.$i];
						$ret=$problem_object->add_itil_relation($data,VIS_STAFF_ID, VIS_LOCATION_AREA);
						
						$filter = " attach_type=".$data['vis_attach_type']." AND child_id=".$data['vis_child_id']." AND parent_id=".$data['vis_parent_id'];
						list($total_ticket, $attached_ticket)=$problem_object->get_ticket_attached_problem($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
						$changes_object->add_audit_log($changes_details[0], 11, $attached_ticket[0]['ticket_name'],'', VIS_STAFF_ID, VIS_LOCATION_AREA);
					}
				}
				if($ret){
					if($operation['ci_for']=='changes'){ 
						echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_details_list_".$data['vis_changes_id']."').visExecution('load_operations',{'vis_module':'changes', 'vis_operation':'get_details', 'vis_action':'details', 'vis_changes_id':'".$data['vis_changes_id']."' });
						$('#tot_tick_cnt').val(".$data['total_attach_count'].");						set_active_tab('ticket_details');$('.modal').modal('toggle');</script>";
					}
				}
			}
		}
		else{
			
			$database->database_disconnect();
			include(VIS_PATH_TEMPLATE.'changes_attached_ticket.php');
		}
        return true;
	}
	
	function attach_problem($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);
		
		if(isset($operation['vis_attach_problem']) && $operation['vis_attach_problem']=='success'){
			$data=parse_form_array($operation['vis_action']);
			
			if($data['total_attach_count']>0){
				$data['vis_attach_type']=2;
				$data['vis_child_id']=$data['vis_changes_id'];
				$filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$data['vis_changes_id'];
				list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				for($i=0;$i<$data['total_attach_count'];$i++){
					
					if(isset($data['vis_attach_id_'.$i])){
						$data['vis_parent_id']=$data['vis_attach_id_'.$i];
						$ret=$problem_object->add_itil_relation($data,VIS_STAFF_ID, VIS_LOCATION_AREA);
						
						$filter = " attach_type=".$data['vis_attach_type']." AND child_id=".$data['vis_child_id']." AND parent_id=".$data['vis_parent_id'];
						list($total_problem, $attached_problem)=$changes_object->get_attached_problem($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
						$changes_object->add_audit_log($changes_details[0], 12, $attached_problem[0]['problem_name'],'', VIS_STAFF_ID, VIS_LOCATION_AREA);
					}
				}
				if($ret){
					if($operation['ci_for']=='changes'){ 
						echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_details_list_".$data['vis_changes_id']."').visExecution('load_operations',{'vis_module':'changes', 'vis_operation':'get_details', 'vis_action':'details', 'vis_changes_id':'".$data['vis_changes_id']."' }); set_active_tab('ticket_details');$('.modal').modal('toggle');</script>";
					}
				}
			}
		}
		else{
			
			$database->database_disconnect();
			include(VIS_PATH_TEMPLATE.'changes_attached_problem.php');
		}
        return true;
	}
	function attach_ci($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);
		
		if(isset($operation['vis_attach_ci']) && $operation['vis_attach_ci']=='success'){
			$data=parse_form_array($operation['vis_action']);
			$flag=0;
			if($data['total_attach_count']>0){
				$data['vis_attach_type']=9;
				$data['vis_parent_id']=$data['vis_changes_id'];
				$filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$data['vis_changes_id'];
				list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				for($i=0;$i<$data['total_attach_count'];$i++){
					
					if(isset($data['vis_attach_id_'.$i])){
						$flag=1;
						$data['vis_child_id']=$data['vis_attach_id_'.$i];
						$ret=$problem_object->add_itil_relation($data,VIS_STAFF_ID, VIS_LOCATION_AREA);
						
						$filter = " attach_type=9 AND child_id=".$data['vis_child_id']." AND parent_id=".$data['vis_parent_id'];
						list($total_ci, $attached_ci)=$problem_object->get_attach_ci($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
						$changes_object->add_audit_log($changes_details[0], 10, $attached_ci[0]['name'],'', VIS_STAFF_ID, VIS_LOCATION_AREA);
					}
				}
				if($ret){
					if($operation['ci_for']=='changes'){ 
						echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_details_list_".$data['vis_changes_id']."').visExecution('load_operations',{'vis_module':'changes', 'vis_operation':'get_details', 'vis_action':'details', 'vis_changes_id':'".$data['vis_changes_id']."' }); set_active_tab('ticket_details');$('.modal').modal('toggle');</script>";
					}
				}
			}
		}
		else{
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            $setting_object=new class_setting($database);
			$department_id=0;
			if(isset($operation['vis_department'])) $department_id=$operation['vis_department'];
			$filter = " and (".VIS_TABLE_PREFIX."itil_configuration_item.department_access = 0 OR FIND_IN_SET($department_id, ".VIS_TABLE_PREFIX."itil_configuration_item.department_access)>0)";
			$confi_item_details=$setting_object->get_configuration_item($filter,0, -1, '', VIS_STAFF_ID);
			
			//$confi_item_details=$setting_object->get_configuration_item_category('','is_enabled=1');
			$database->database_disconnect();
			include(VIS_PATH_TEMPLATE.'changes_attach_ci.php');
		}
        return true;
	}
	
	function attach_task($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);
		
		if(isset($operation['vis_attach_task']) && $operation['vis_attach_task']=='success'){
			$data=parse_form_array($operation['vis_action']);
			
			if($data['total_attach_count']>0){
				$data['vis_attach_type']=10;
				$data['vis_parent_id']=$data['vis_changes_id'];
				
				$filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$data['vis_changes_id'];
				list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				
				for($i=0;$i<$data['total_attach_count'];$i++){
					
					if(isset($data['vis_attach_id_'.$i])){
						$data['vis_child_id']=$data['vis_attach_id_'.$i];
						$ret=$problem_object->add_itil_relation($data,VIS_STAFF_ID, VIS_LOCATION_AREA);
						
						$filter = " attach_type=10 AND child_id=".$data['vis_child_id']." AND parent_id=".$data['vis_parent_id'];
						list($total_task, $attached_task)=$problem_object->get_task_attachedto_problem($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
						$changes_object->add_audit_log($changes_details[0], 14, $attached_task[0]['task_title'],'', VIS_STAFF_ID, VIS_LOCATION_AREA);
					}
				}
				if($ret){
					if($operation['ci_for']=='changes'){ 
						echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_details_list_".$data['vis_changes_id']."').visExecution('load_operations',{'vis_module':'changes', 'vis_operation':'get_details', 'vis_action':'details', 'vis_changes_id':'".$data['vis_changes_id']."' }); set_active_tab('ticket_details');$('.modal').modal('toggle');</script>";
					}
				}
			}
		}
		else{
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            $setting_object=new class_setting($database);
			$confi_item_details=$setting_object->get_configuration_item_category('','is_enabled=1');
			$database->database_disconnect();
			include(VIS_PATH_TEMPLATE.'changes_attached_task.php');
		}
        return true;
	}
	
	function attach_release($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);
		
		if(isset($operation['vis_attach_release']) && $operation['vis_attach_release']=='success'){
			$data=parse_form_array($operation['vis_action']);
			if(isset($data['vis_attach_id'])){
				$data1['vis_attach_type']=3;
				$data1['vis_parent_id']=$data['vis_changes_id'];
				$data1['vis_child_id']=$data['vis_attach_id'];
				$ret=$problem_object->add_itil_relation($data1,VIS_STAFF_ID, VIS_LOCATION_AREA);
				
				$filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$data['vis_changes_id'];
				list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				
				$filter = " attach_type=3 AND child_id=".$data1['vis_child_id']." AND parent_id=".$data1['vis_parent_id'];
				list($total_changes, $attached_changes)=$problem_object->get_changes_attachedto_problem($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
				$problem_object->add_audit_log($changes_details[0], 13, $attached_changes[0]['changes_name'],'', VIS_STAFF_ID, VIS_LOCATION_AREA);
						
				if($ret){
					if($operation['ci_for']=='changes'){ 
						echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_details_list_".$data['vis_changes_id']."').visExecution('load_operations',{'vis_module':'changes', 'vis_operation':'get_details', 'vis_action':'details', 'vis_changes_id':'".$data['vis_changes_id']."' }); set_active_tab('ticket_details');$('.modal').modal('toggle');</script>";
					}
				}
			}
		}
		else{
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            $setting_object=new class_setting($database);
			$confi_item_details=$setting_object->get_configuration_item_category('','is_enabled=1');
			$database->database_disconnect();
			include(VIS_PATH_TEMPLATE.'changes_attached_release.php');
		}
        return true;
	}
	function get_release_list($operation){
		global $vis_language;
		$database=new class_database();
	    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $release_object=new class_releases($database);
        $filter = '';
		$filter .= ' '.VIS_TABLE_PREFIX.'itil_releases.domain_id='.$operation['vis_domain_id']." AND ";
		
        if(isset($operation['vis_filter']) && $operation['vis_filter']!=''){
			$filter .= VIS_TABLE_PREFIX."itil_releases.subject like '%".addslashes($operation['vis_filter'])."%' AND ";
		}
		$filter=substr($filter, 0, -4);
		list($releases_info, $releases_details)=$release_object->get_releases($filter, '50', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$tbl_data='';
		if($releases_details!=-1){
			$tbl_data .= '<table class="table table-hover b-t b-light m-b-none" id="table_ticket_relation">
								<thead class="table_head">
									<tr>
										<th></th>
										<th>'.$vis_language['TXTNAME'].'</th>
										<th>'.$vis_language['TXTDEPARTMENT'].'</th>
										<th>'.$vis_language['TXTSTATUS'].'</th>						
									</tr>
								</thead>';
			
			for($i=0;$i<count($releases_details);$i++){
				$tbl_data.='<tr>';
				$tbl_data.='<td><label class="radio m-n i-checks"><input type="radio" name="vis_attach_id" id="vis_attach_id" value="'.$releases_details[$i]['release_id'].'" /><i></i></label></td>';
				
				$tbl_data.='<td>'.$releases_details[$i]['subject'].'</td><td>'.$releases_details[0]['department_name'].'</td><td>'.$releases_details[$i]['status_name'].'</td></tr>';
			}
		}
		if($tbl_data==''){
			$tbl_data .='<div style="text-align:center;">'.$vis_language['TXTNOMATCHFOUND'].'</div>';
		}else{
			$tbl_data .= '</table><script type="application/javascript">$(document).ready(function() {$("#table_ticket_relation").dataTable({ "sScrollY":  ( 0.6 * $(window).height() ),"bPaginate": false, "bJQueryUI": true, "bScrollCollapse": true, "bAutoWidth": "90%", "scrollX": true, "sScrollXInner": "100%","bFilter": false,"bInfo": false,"ordering": false});});</script>';
		}
		echo json_encode(array('list' => $tbl_data));
        return true;
	}
	
	function get_problem_list($operation){
		global $vis_language;
		$database=new class_database();
	    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		$filter ='';
		$filter .= ' '.VIS_TABLE_PREFIX.'itil_problems.domain_id='.$operation['vis_domain_id']." AND ";
		
        if(isset($operation['vis_filter'])){
			$filter .= VIS_TABLE_PREFIX."itil_problems.subject like '%".addslashes($operation['vis_filter'])."%' AND ";
		}
		$filter=substr($filter, 0, -4);
		if(isset($operation['attached_id']) && $operation['attached_id']!=""){
			$selected_ci=explode(',', $operation['attached_id']);
			for($i=0;$i<count($selected_ci)-1;$i++){
				if($filter!='')$filter .=' and ';
				$filter .= ' '.VIS_TABLE_PREFIX.'itil_problems.problem_id!='.$selected_ci[$i];
			}
		}
		list($problems_info, $problems_details)=$problem_object->get_problems($filter, '50', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $tbl_data='';
		if($problems_details!=-1){
			$tbl_data .= '<table class="table table-hover b-t b-light m-b-none" id="table_ticket_relation">
								<thead class="table_head">
									<tr>
										<th></th>
										<th>'.$vis_language['TXTNAME'].'</th>
										<th>'.$vis_language['TXTDEPARTMENT'].'</th>
										<th>'.$vis_language['TXTSTATUS'].'</th>						
									</tr>
								</thead>';
			
			for($i=0;$i<count($problems_details);$i++){
				$tbl_data.='<tr>';
				$tbl_data.='<td><label class="checkbox m-n i-checks"><input type="checkbox" name="vis_attach_id_'.$i.'" id="vis_attach_id_'.$i.'" value="'.$problems_details[$i]['problem_id'].'" /><i></i></label></td>';
				
				$tbl_data.='<td>'.$problems_details[$i]['subject'].'</td><td>'.$problems_details[0]['department_name'].'</td><td>'.$problems_details[$i]['status_name'].'</td></tr>';
			}
		}
		if($tbl_data==''){
			$tbl_data .='<div style="text-align:center;">'.$vis_language['TXTNOMATCHFOUND'].'</div>';
			$tbl_data .='<input type="hidden" name="total_attach_count" id="total_attach_count" value="0">';
		}else{
			$tbl_data .='</table><input type="hidden" name="total_attach_count" id="total_attach_count" value="'.count($problems_details).'">';
			$tbl_data .= '<script type="application/javascript">$(document).ready(function() {$("#table_ticket_relation").dataTable({ "sScrollY":  ( 0.6 * $(window).height() ),"bPaginate": false, "bJQueryUI": true, "bScrollCollapse": true, "bAutoWidth": "100%", "scrollX": true, "sScrollXInner": "100%","bFilter": false,"bInfo": false,"ordering": false});});</script>';
		}
		
		echo json_encode(array('list' => $tbl_data));
        return true;
	}
	function changes_planning_form($operation) {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);
		
        $filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$operation['vis_changes_id'];
		list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		
        $changes_details=$changes_details[0];$attachments=-1;
		if (defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR != 1) {  	
         $changes_details['reason'] = get_plain_text( $changes_details['reason']);
         $changes_details['impact_planning'] = get_plain_text( $changes_details['impact_planning']);
		}
		if($operation['vis_planning_type']=='reasons'){
			if($changes_details['reasons_attachment']!=''){ 
				$attachments=$problem_object->get_problem_attachment($changes_details['reasons_attachment'], VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}
		if($operation['vis_planning_type']=='impact'){
			if($changes_details['impact_attachment']!=''){ 
				$attachments=$problem_object->get_problem_attachment($changes_details['impact_attachment'], VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}
		
		$database->database_disconnect();
		include(VIS_PATH_TEMPLATE.'changes_planning_update.php');
        return true;
    }
	function update_changes_planning($operation) {
        global $vis_language;
		
        $data=parse_form_array($operation['vis_action']);
		if(!isset($data['vis_planning_desc']) || trim(strip_tags($data['vis_planning_desc'],"<img>"))==''){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDDESC'].'"); </script>';
            return false;
        }
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);
		$data['planning_type'] = $operation['vis_planning_type'];
		if(defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR==0) 
		$data['vis_planning_desc'] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_planning_desc']);
		$result=$changes_object->update_changes_planning($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if(!$result)
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
        else {
			
            echo "<script>$('#vis_changes_planning_show_".$data['vis_changes_id']."').visExecution('load_area',{'vis_module':'changes', 'vis_operation':'get_details','vis_action': 'planning', 'vis_planning_type': '".$data['planning_type']."', 'vis_changes_id':".$data['vis_changes_id']."});</script>";
		}
        return $result;
    }
	function confirm_delete_planning($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETE'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$(this).visExecution('load_operations', {'vis_module':'changes', 'vis_operation':'delete_planning', 'vis_changes_id':".$operation['vis_changes_id'].", 'vis_planning_type':'".$operation['vis_planning_type']."'});";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	function delete_planning($operation) {
        global $vis_language;
		$database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);
        $result = $changes_object->delete_planning($operation, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if($result) {
			echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_changes_planning_show_".$operation['vis_changes_id']."').visExecution('load_area',{'vis_module':'changes', 'vis_operation':'get_details','vis_action': 'planning', 'vis_planning_type': '".$operation['vis_planning_type']."', 'vis_changes_id':".$operation['vis_changes_id']."});</script>";
			
		}
		else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
        return $result;
    }
	
	function changes_plan_form($operation) {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);
        $filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$operation['vis_changes_id'];
		list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $changes_details=$changes_details[0];
        if (defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR != 1) {  	
         $changes_details['rollout'] = get_plain_text( $changes_details['rollout']);
         $changes_details['backout'] = get_plain_text( $changes_details['backout']);
		}
		$rollout_attachment = $backout_attachment = -1;
					
		if($changes_details['rollout_attachment']!=''){ 
			$rollout_attachment=$problem_object->get_problem_attachment($changes_details['rollout_attachment'], VIS_STAFF_ID, VIS_LOCATION_AREA);
		}
		if($changes_details['backout_attachment']!=''){ 
			$backout_attachment	=$problem_object->get_problem_attachment($changes_details['backout_attachment'], VIS_STAFF_ID, VIS_LOCATION_AREA);
		}
		
		$database->database_disconnect();
		include(VIS_PATH_TEMPLATE.'changes_plan_update.php');
        return true;
    }
	function update_change_plan($operation){
		global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);
		$data=parse_form_array($operation['vis_action']);
		if (defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR != 1) 
		$data['vis_description'] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_description']);

		$data['vis_plan_type'] = $operation['vis_plan_type'];
		$result=$changes_object->update_changes_planning($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if(!$result)
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
        else {
            echo "<script> $('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."'); $('#vis_solution_".$data['vis_changes_id']."').visExecution('load_operations',{'vis_module':'changes', 'vis_operation':'get_details', 'vis_action':'plan', 'vis_changes_id':'".$data['vis_changes_id']."'});</script>";
		}
        return $result;
	}
	function confirm_delete_plan($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETE'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$(this).visExecution('load_operations', {'vis_module':'changes', 'vis_operation':'delete_plan', 'vis_changes_id':".$operation['vis_changes_id'].", 'vis_plan_type':'".$operation['vis_plan_type']."'});";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	function delete_plan($operation) {
        global $vis_language;
		$database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);
        $result = $changes_object->delete_planning($operation, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if($result) {
			echo "<script> $('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."'); $('#vis_solution_".$operation['vis_changes_id']."').visExecution('load_operations',{'vis_module':'changes', 'vis_operation':'get_details', 'vis_action':'plan', 'vis_changes_id':'".$operation['vis_changes_id']."'});</script>";
		}
		else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
        return $result;
    }
	
	function send_aprovals($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff_object=new class_staff($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'mail.php');
		$mobject=new class_mail($database);	
		
		if(isset($operation['vis_send_request']) && $operation['vis_send_request']=='success'){
			$data=parse_form_array($operation['vis_action']);

					
			if(($data['total_group']>0) && $data['member']=='team' )
			{   // echo "In group";
		         $staffid_in_group=array();
				 $groupid=array();
				 $staffid_bygroup_details=array();
				 $filter_data=array();
				 $iddata=array();
				 
				
					$query_string="";
					
					$grpid=array();
					for($i=0;$i<$data['total_group'];$i++)
					{
					 if(isset($data['vis_group_id_'.$i]))
					 {
						$grpid[$i]=$data['vis_group_id_'.$i];
					 }	
					}
				
					$group_count=count($grpid);
					
					
						for($i=0;$i<$data['total_group'];$i++)
					{
					 if($group_count>1)
						{
							
					
						if(isset($data['vis_group_id_'.$i]))
						{
							if($i==($group_count-1))
							{ 
						        
								$query_string[]=$data['vis_group_id_'.$i];
							}
							else
							{
								
							$query_string[]=$data['vis_group_id_'.$i];
							}
						}
						}
						else
						{
							if(isset($data['vis_group_id_'.$i])){
							
							$query_string[]=$data['vis_group_id_'.$i];
							}
						}	
					}
					
					$query_filter=VIS_TABLE_PREFIX.'staff.is_enabled=1 and '.VIS_TABLE_PREFIX.'staff.group_id in ('.implode(',',$query_string).') and '.VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_dept_id'];
					
					//$query_filter=VIS_TABLE_PREFIX.'staff.is_enabled=1 and '.VIS_TABLE_PREFIX.'staff.group_id in ('.implode(',',$query_string).')';
					//THIS ONE FOR EMPTY GRPS
					list($staffid_bygroup_details,$emptygroup)=$staff_object->get_staffid_in_group($query_filter, VIS_STAFF_ID, VIS_LOCATION_AREA); 
							
					if(count($query_string)>count($emptygroup)){
						$totals=count($query_string);
					}else{
						$totals=count($emptygroup);
					}
					
					for($i=0;$i<$totals;$i++){
						for($j=0;$j<count($emptygroup);$j++){
							if($query_string[$i]==$emptygroup[$j]['group_id']){
								$empty_groups[$j]=$emptygroup[$j]['group_id'];
							}
						}
					}
					
					$ids=implode(',',$empty_groups);
					$staffgroup_list = $staff_object->get_staff_group('is_enabled=1 and group_id in('.$ids.')',VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($staffgroup_list!=-1){
					for($i=0;$i<count($staffgroup_list);$i++){
					$teamarray[$i]=$staffgroup_list[$i]['group_name'];
					}
					$team_names=implode(',',$teamarray);
					$team_names="No staff in ".$team_names." team";
					
					if(!empty($teamarray)){ 						
						echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$team_names."')</script>";
						return false;
					}
					}
				
				$data['vis_parent_id']=$data['vis_changes_id'];
				$filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$data['vis_changes_id'];
				list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				for($i=0;$i<$data['total_staff'];$i++){
				
						if(isset($staffid_bygroup_details[$i]['staff_id'])){
						
						$data['vis_staff_id']=$staffid_bygroup_details[$i]['staff_id'];
				
						
						$filter = VIS_TABLE_PREFIX.'itil_changes_aprovals.parent_id='.$data['vis_parent_id'].' AND aprovals_type=0 AND '.VIS_TABLE_PREFIX.'itil_changes_aprovals.staff_id='.$data['vis_staff_id'];
						list($aprovals_info, $aprovals_details)=$changes_object->get_aprovals($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
						if($aprovals_details !=-1){
							$filter =' parent_id='.$data['vis_parent_id'].' AND staff_id='.$data['vis_staff_id'];
							$ret=$changes_object->disabled_aprovals($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
						}
				
						$ret=$changes_object->add_aprovals($data,VIS_STAFF_ID, VIS_LOCATION_AREA);
						
						$staff_list = $staff_object->get_staff('is_enabled=1 and staff_id='.$data['vis_staff_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
												
						$data1['changes_name']=$changes_details[0]['subject'];
						$data1['domain_id']=$changes_details[0]['domain_id'];
						$data1['changes_hash']=$changes_details[0]['changes_hash'];
						$data1['staff']=$staff_list[0];
						$data1['template_id']=17;
						
						$data1['vis_module']='changes';
						$data1['changes_id']=$data['vis_changes_id'];
						$rert=$mobject->email_notify($data1, 'changes_aproval_mail', VIS_STAFF_ID, VIS_LOCATION_AREA);
						
						$changes_object->add_audit_log($changes_details[0], 20, $staff_list[0]['first_name'].' '.$staff_list[0]['last_name'],'', VIS_STAFF_ID, VIS_LOCATION_AREA);
					}
				}
				if($ret){
					echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_details_list_".$data['vis_changes_id']."').visExecution('load_operations',{'vis_module':'changes', 'vis_operation':'get_details', 'vis_action':'details', 'vis_changes_id':'".$data['vis_changes_id']."', 'open_aprovals':'yes' }); set_active_tab('ticket_details');$('.modal').modal('toggle');</script>";
				}
			
             				
			}
			elseif($data['total_staff']>0){
				
				$data['vis_parent_id']=$data['vis_changes_id'];
				$filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$data['vis_changes_id'];
				list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				for($i=0;$i<$data['total_staff'];$i++){
					
					if(isset($data['vis_staff_id_'.$i])){
						
						$data['vis_staff_id']=$data['vis_staff_id_'.$i];
						$filter = VIS_TABLE_PREFIX.'itil_changes_aprovals.parent_id='.$data['vis_parent_id'].' AND aprovals_type=0 AND '.VIS_TABLE_PREFIX.'itil_changes_aprovals.staff_id='.$data['vis_staff_id'];
						list($aprovals_info, $aprovals_details)=$changes_object->get_aprovals($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
						if($aprovals_details !=-1){
							$filter =' parent_id='.$data['vis_parent_id'].' AND staff_id='.$data['vis_staff_id'];
							$ret=$changes_object->disabled_aprovals($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
						}
						$ret=$changes_object->add_aprovals($data,VIS_STAFF_ID, VIS_LOCATION_AREA);
						
						$staff_list = $staff_object->get_staff('is_enabled=1 and staff_id='.$data['vis_staff_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
												
						$data1['changes_name']=$changes_details[0]['subject'];
						$data1['domain_id']=$changes_details[0]['domain_id'];
						$data1['changes_hash']=$changes_details[0]['changes_hash'];
						$data1['staff']=$staff_list[0];
						$data1['template_id']=17;
						
						$data1['vis_module']='changes';
						$data1['changes_id']=$data['vis_changes_id'];
						$rert=$mobject->email_notify($data1, 'changes_aproval_mail', VIS_STAFF_ID, VIS_LOCATION_AREA);
						
						$changes_object->add_audit_log($changes_details[0], 20, $staff_list[0]['first_name'].' '.$staff_list[0]['last_name'],'', VIS_STAFF_ID, VIS_LOCATION_AREA);
					}
				}
				if($ret){
					echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_details_list_".$data['vis_changes_id']."').visExecution('load_operations',{'vis_module':'changes', 'vis_operation':'get_details', 'vis_action':'details', 'vis_changes_id':'".$data['vis_changes_id']."', 'open_aprovals':'yes' }); set_active_tab('ticket_details');$('.modal').modal('toggle');</script>";
				}
			}
		}
		else{
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
			$problem_object=new class_problem($database);
			$owner_details=-1;
			if($problems_details['staff_id']!='' && $problems_details['staff_id']!='0'){
				$owner_details=$problem_object->get_problem_owner($problems_details['staff_id']);
			}
		
			$staff_list = $staff_object->get_staff('is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA, $operation['vis_dept_id']);
			$staffgroup_list = $staff_object->get_staff_group('is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA);
			$database->database_disconnect();
			include(VIS_PATH_TEMPLATE.'changes_sendaprovals_request.php');
		}
        return true;
	}
	
	function change_aprove_status($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
		$changes_object=new class_changes($database);
				
		$filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$operation['vis_changes_id'];
		list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				
		$ret=$changes_object->update_aprove_status($operation, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
		}else{
		
			$status = $operation['status'];
			$status = ($status==1)? 'Aproved' : (($status==2)? 'Canceled' : 'Rejected');
			$changes_object->add_audit_log($changes_details[0], 21, $status, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		}
	
		$database->database_disconnect();
		return $ret;
		
	}
	function reject_aprovals($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
		$changes_object=new class_changes($database);
			
		if(isset($operation['vis_reject']) && $operation['vis_reject']=='success'){
			$data=parse_form_array($operation['vis_action']);
			if(trim($data['vis_remark'])==''){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDDESC'].'"); </script>';
				return false;
			}
		
			$filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$data['vis_changes_id'];
			list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
					
			$ret=$changes_object->update_aprove_remark($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
			if(!$ret){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
				return false;
			}else{
				echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_details_list_".$data['vis_changes_id']."').visExecution('load_operations',{'vis_module':'changes', 'vis_operation':'get_details', 'vis_action':'details', 'vis_changes_id':'".$data['vis_changes_id']."', 'open_aprovals':'yes'}); set_active_tab('ticket_details');$('.modal').modal('toggle');</script>";
			}
		}
		else{
			include(VIS_PATH_TEMPLATE.'changes_remark.php');
		}
		return true;
	}
	function send_aprove_reminder($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
		$changes_object=new class_changes($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'mail.php');
		$mobject=new class_mail($database);	
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff_object=new class_staff($database);	
		$ret = -1;
		$filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$operation['vis_changes_id'];
		list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		if($changes_details!=-1){
			
			$filter = VIS_TABLE_PREFIX.'itil_changes_aprovals.parent_id='.$operation['vis_changes_id'].' AND aprovals_type=0 AND '.VIS_TABLE_PREFIX.'itil_changes_aprovals.staff_id='.$operation['staff_id'].' AND '.VIS_TABLE_PREFIX.'itil_changes_aprovals.aprovals_id='.$operation['aprove_id'];
			list($aprovals_info, $aprovals_details)=$changes_object->get_aprovals($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			
			if($aprovals_details !=-1){			
				$staff_list = $staff_object->get_staff('is_enabled=1 and staff_id='.$operation['staff_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
				if($staff_list!=-1){
					$data1['changes_name']=$changes_details[0]['subject'];
					$data1['domain_id']=$changes_details[0]['domain_id'];
					$data1['changes_hash']=$changes_details[0]['changes_hash'];
					$data1['staff']=$staff_list[0];
					$data1['template_id']=17;
									
					$data1['vis_module']='changes';
					$data1['changes_id']=$operation['vis_changes_id'];
					$ret=$mobject->email_notify($data1, 'changes_aproval_mail', VIS_STAFF_ID, VIS_LOCATION_AREA);
					$changes_object->add_audit_log($changes_details[0], 30, $staff_list[0]['first_name'].' '.$staff_list[0]['last_name'],'', VIS_STAFF_ID, VIS_LOCATION_AREA);
				}	
			}
		}
		return $ret;
	}
	
	function load_inline_images($operation) {
		global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $object = new class_changes($database);
        $filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$operation['vis_post_id'];
        list($changes_info, $changes_details)=$object->get_changes($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		if($operation['vis_type']=='desc')
			$content=stripslashes($changes_details[0]['description']);
		elseif($operation['vis_type']=='reasons')
			$content=stripslashes($changes_details[0]['reason']);
		elseif($operation['vis_type']=='impact')
			$content=stripslashes($changes_details[0]['impact_planning']);
			
        if($operation['vis_display'])
			echo json_encode( array('vis_post_content_html' => $content) );
        else  
			echo json_encode( array('vis_post_content_html' => preg_replace("/<img[^>]+\>/i", " ", $content)) );
		
        $database->database_disconnect();
	}
	function get_risk_list($operation)
	{
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		$vis_department_id= $operation['department_id'];
		$filter_condtn = '(department_access=0 or department_access in ('.$vis_department_id.'))';
		$risk=$ticket_module->get_properties('get_risks', '', $filter_condtn);	
		$database->database_disconnect();
		if($risk!='')
        echo get_xml($risk, 'risk');
        else echo $vis_language['MSGDATANOTFND'];
        return true;
	}
	function get_change_type_list($operation)
	{
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		$vis_department_id= $operation['department_id'];
		$filter_condtn = '(department_access=0 or department_access in ('.$vis_department_id.'))';
		$change_type_details=$ticket_module->get_properties('get_changetype', '', $filter_condtn);	
		$database->database_disconnect();
		if($change_type_details!='')
        echo get_xml($change_type_details, 'changetype');
        else echo $vis_language['MSGDATANOTFND'];
        return true;
	}
}
?>
